<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 04.12.13 10:15
 */

namespace VM\PackageGeneratorBundle\Services\Export;


class StructureXml extends AbstractStructure implements StructureInterface
{
    /**
     * @var \DOMDocument
     */
    protected $XML;

    /**
     * @var \DOMElement
     */
    protected $Root;


    public function get($path, $authCode, $title = '')
    {
        $this->XML = new \DOMDocument('1.0', 'utf-8');
        $this->Root = $this->XML->createElement('flipbook');
        $this->XML->appendChild($this->Root);

        $this->addSettingsSection($authCode, $title);
        $this->addContentSection($path);
        $this->addToolbarSection();
        return str_replace('<?xml version="1.0" encoding="utf-8"?>' . "\n", '', $this->XML->saveXML());
    }


    protected function addSettingsSection($authCode, $title)
    {
        $Settings = $this->XML->createElement('settings');
        $ID = $this->XML->createElement('flipbook_id', 'test');
        $Ver = $this->XML->createElement('flipbook_ver', 1);
        $ProductId = $this->XML->createElement('product_id', '001');
        $Title = $this->XML->createElement('title', $title);
        $ProductCode = $this->XML->createElement('productCode', $authCode);
        $Type = $this->XML->createElement('type', 'report');

        $Settings->appendChild($ID);
        $Settings->appendChild($Ver);
        $Settings->appendChild($ProductId);
        $Settings->appendChild($Title);
        $Settings->appendChild($ProductCode);
        $Settings->appendChild($Type);
        $this->Root->appendChild($Settings);
    }


    protected function addToolbarSection()
    {
        $Toolbar = $this->XML->createElement('toolbar', 'otherXmls/toolbar.xml');
        $Toolbar->setAttribute('type', 'file');

        $this->Root->appendChild($Toolbar);
    }


    protected function addOtherOptions()
    {
        $Interactions = $this->XML->createElement('interactions', 'some/path');
        $Interactions->setAttribute('type', 'file');
        $this->Root->appendChild($Interactions);


        $About = $this->XML->createElement('about', 'otherXmls/about.xml');
        $this->Root->appendChild($About);

        $Logo = $this->XML->createElement('logo', 'logo.swf');
        $this->Root->appendChild($Logo);

        $ContentsList = $this->XML->createElement('contentsList', 'contents.xml');
        $this->Root->appendChild($ContentsList);

        $Index = $this->XML->createElement('index', 'otherXmls/index.swf');
        $this->Root->appendChild($Index);

        $Timer = $this->XML->createElement('timer', 'media/test.mp3');
        $this->Root->appendChild($Timer);

        $Toolbar = $this->XML->createElement('toolbar', 'otherXmls/toolbar.xml');
        $Toolbar->setAttribute('type', 'file');
        $this->Root->appendChild($Toolbar);
    }


    protected function addMarkerObject()
    {
        $MarkerObject = $this->XML->createElement('markerObjects');
        $this->Root->appendChild($MarkerObject);

        $DigitalBook = $this->XML->createElement('digitalBook');
        $DigitalBook->setAttribute('scale', 'content');
        $DigitalBook->setAttribute('transparency', 'true');
        $DigitalBook->setAttribute('btnExit', 'false');

        $Toolbar = $this->XML->createElement('toolbar', 'otherXmls/marker.xml');
        $Toolbar->setAttribute('type', 'file');

        $MarkerObject->appendChild($DigitalBook)->appendChild($Toolbar);


        $TeachersArea = $this->XML->createElement('teachersArea');
        $TeachersArea->setAttribute('bottom_margin', 70);
        $TeachersArea->setAttribute('v_margin', 30);
        $TeachersArea->setAttribute('h_margin', 30);

        $Toolbar = $this->XML->createElement('toolbar', 'otherXmls/marker.xml');
        $Toolbar->setAttribute('type', 'file');

        $MarkerObject->appendChild($TeachersArea)->appendChild($Toolbar);


        $InteractionsArea = $this->XML->createElement('interactionsArea');
        $InteractionsArea->setAttribute('bottom_margin', 51);
        $InteractionsArea->setAttribute('v_margin', 5);
        $InteractionsArea->setAttribute('h_margin', 5);
        $InteractionsArea->setAttribute('btnExit', false);
        $InteractionsArea->setAttribute('scale', 'interactions');

        $Toolbar = $this->XML->createElement('toolbar', 'otherXmls/marker.xml');
        $Toolbar->setAttribute('type', 'file');

        $MarkerObject->appendChild($InteractionsArea)->appendChild($Toolbar);
    }


    protected function addContentSection($path)
    {
        $files = $this->getSortedListOfFiles($path);

        $Content = $this->XML->createElement('content');
        $this->Root->appendChild($Content);

        $Content->setAttribute('first_spread', 0);
        $Content->setAttribute('arrows_pos', 'top');
        $Content->setAttribute('v_margin', 67);
        $Content->setAttribute('h_margin', 30);
        $Content->setAttribute('top_margin', 10);
        $Content->setAttribute('frame', 100);
        $Content->setAttribute('toolbar_width', 35);


        $PageSize = $this->XML->createElement('page_size');
        $PageSize->setAttribute('width', $this->pageWidth);
        $PageSize->setAttribute('height', $this->pageHeight);
        $Content->appendChild($PageSize);

        $i = 1;
        foreach($files as $filename)
        {
            $Spread = $this->XML->createElement('spread');
            $Content->appendChild($Spread);

            $Page = $this->XML->createElement('page');
            $Page->setAttribute('id', $i);
            $Page->setAttribute('number', $i);
            $Spread->appendChild($Page);

            $Page->appendChild($this->XML->createElement('pagePath', 'swf/page_' . $i . '.swf'));
            $Page->appendChild($this->XML->createElement('preview', 'swf/page_' . $i . '.swf'));
            $i++;
        }
    }

} 